package com.ejie.ab04b.evento;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.AB04BParseException;
import com.ejie.ab04b.model.ComunicacionProcedimiento;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaProcedimiento;
import com.ejie.ab04b.model.TramiteProcedimiento;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;
import com.ejie.foldermanagement.xml.DocumentsEvent;
import com.ejie.mbt.xml.Task;

/**
 * @author GFI-NORTE
 * 
 */
public interface ManejadorTareas {

	/**
	 * Find expediente by folder id.
	 * 
	 * folderId String ComunicacionProcedimiento
	 *
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion procedimiento
	 */
	public ComunicacionProcedimiento findExpedienteByFolderId(String folderId);

	/**
	 * Obtener folder number by folder id.
	 * 
	 * folderId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @return the string
	 */
	public String obtenerFolderNumberByFolderId(String folderId);

	/**
	 * Gets the territorio expediente by folder id.
	 * 
	 * folderId String String
	 *
	 * @param folderId
	 *            the folder id
	 * @return the territorio expediente by folder id
	 */
	public String getTerritorioExpedienteByFolderId(String folderId);

	/**
	 * Crear tramite tarea sugerida.
	 * 
	 * task Task tipoTarea Tarea TramiteProcedimiento
	 *
	 * @param task
	 *            the task
	 * @param tipoTarea
	 *            the tipo tarea
	 * @return the tramite procedimiento
	 */
	public TramiteProcedimiento crearTramiteTareaSugerida(Task task,
			Tarea tipoTarea);

	/**
	 * Crear tarea sugerida.
	 * 
	 * task Task tipoTarea Tarea tramite TramiteProcedimiento TareaProcedimiento
	 *
	 * @param task
	 *            the task
	 * @param tipoTarea
	 *            the tipo tarea
	 * @param tramite
	 *            the tramite
	 * @return the tarea procedimiento
	 */
	public TareaProcedimiento crearTareaSugerida(Task task, Tarea tipoTarea,
			TramiteProcedimiento tramite);

	/**
	 * Crear expediente.
	 * 
	 * sdetailInfo String contextSubmission ContextSubmissionEvent
	 *
	 * @param sdetailInfo
	 *            the sdetail info
	 * @param contextSubmission
	 *            the context submission
	 * @throws AB04BParseException
	 *             excepción al parsear el objeto DetailInfo
	 */
	public void crearExpediente(String sdetailInfo,
			ContextSubmissionEvent contextSubmission)
			throws AB04BParseException;

	/**
	 * Actualizar tarea ejecutada.
	 * 
	 * task Task
	 *
	 * @param task
	 *            the task
	 * @throws AB04BException
	 */
	public void actualizarTareaEjecutada(Task task) throws AB04BException;

	/**
	 * Obtener tramite padre existente.
	 * 
	 * tipoTarea Tarea comunicacion ComunicacionProcedimiento
	 * TramiteProcedimiento
	 *
	 * @param tipoTarea
	 *            the tipo tarea
	 * @param comunicacion
	 *            the comunicacion
	 * @return the tramite procedimiento
	 */
	public TramiteProcedimiento obtenerTramitePadreExistente(Tarea tipoTarea,
			ComunicacionProcedimiento comunicacion);

	/**
	 * Ejecutar tarea automatica.
	 * 
	 * tareaGenerica TareaProcedimiento
	 *
	 * @param tareaGenerica
	 *            the tarea generica
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public void ejecutarTareaAutomatica(TareaProcedimiento tareaGenerica)
			throws AB04BException;

	/**
	 * Continuar ejecucion tarea espera transformacion.
	 * 
	 * idTarea Long idDocumento Long
	 *
	 * @param idTarea
	 *            the id tarea
	 * @param idDocumento
	 *            the id documento
	 */
	public void continuarEjecucionTareaEsperaTransformacion(Long idTarea,
			Long idDocumento);

	/**
	 * Process enviar notificacion.
	 * 
	 * task Task
	 *
	 * @param task
	 *            the task
	 */
	public void processEnviarNotificacion(Task task) throws AB04BException;

	/**
	 * Process registrar comunicacion postal.
	 * 
	 * task Task
	 *
	 * @param task
	 *            the task
	 * @throws Exception
	 */
	public void processRegistrarComunicacionPostal(Task task) throws Exception;

	/**
	 * Generar Y obtener id tramite apertura.
	 * 
	 * contextSubmission ContextSubmissionEvent Long
	 *
	 * @param contextSubmission
	 *            the context submission
	 * @return the long
	 * @throws AB04BException
	 */
	public Long generarYObtenerIdTramiteApertura(
			ContextSubmissionEvent contextSubmission) throws AB04BException;

	/**
	 * Guardar documentos solicitud.
	 * 
	 * documents DocumentsEvent fechaCreacion String idTramite Long
	 *
	 * @param documents
	 *            the documents
	 * @param fechaCreacion
	 *            the fecha creacion
	 * @param idTramite
	 *            the id tramite
	 */
	public void guardarDocumentosSolicitud(DocumentsEvent documents,
			String fechaCreacion, Long idTramite);

	/**
	 * Generar Y obtener id tramite Y tarea aportacion.
	 * 
	 * contextSubmission ContextSubmissionEvent Long
	 *
	 * @param contextSubmission
	 *            the context submission
	 * @return the long
	 */
	public Long generarYObtenerIdTramiteYTareaAportacion(
			ContextSubmissionEvent contextSubmission);

	/**
	 * Gets the doc corr expediente by folder id.
	 * 
	 * folderId the folder id the doc corr expediente by folder id
	 *
	 * @param folderId
	 *            the folder id
	 * @return the doc corr expediente by folder id
	 */
	public String getDocCorrExpedienteByFolderId(String folderId);

}
